local MLData = {
	LAU131 = {},
	M260 = {},
	M299 = {
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		category		= CAT_MISSILES,
		connNamePattern	= "Point%03d",
		Count			= 4,
		Cx_pil			= 0.00208,
		modelFileName	= "M299",
		Picture			= "agm114.png",
		Weight_Empty	= 64.9,
	},
}

copy_recursive(MLData.LAU131,	LauncherData.LAU131)
MLData.LAU131.displayNamePrfx	= ("LAU-131 - 7 x %s, 70 %s"):format(cLocStr.LGRkts, cLocStr.mm)
copy_recursive(MLData.M260,		LauncherData.M260)
MLData.M260.displayNamePrfx		= ("M260 - 7 x %s, 70 %s"):format(cLocStr.LGRkts, cLocStr.mm)

--					Kh-31 loadouts					--

declare_loadout({
	CLSID			= "{X-31A}",
	category		= CAT_MISSILES,
	wsTypeOfWeapon	= {4,	4,	8,	53},
	attribute		= {4,	4,	32,	96},
	Count			= 1,
	Cx_pil			= 15.6 / 4096,
	ejectVelocity	= 4,
	ejectPitchRate	= 0,
	Picture			= "kh31a.png",
	displayName		= _("Kh-31A (AS-17 Krypton) - 610kg, AShM, IN & Act Rdr"),
	NatoName		= "(AS-17)",
	Weight			= 610,
	Elements		= {{
		ShapeName	= "X-31",
		Position	= {0.245, 0, 0},
	}},
})

declare_loadout({
	CLSID			= "{X-31P}",
	category		= CAT_MISSILES,
	wsTypeOfWeapon	= {4,	4,	8,	76},
	attribute		= {4,	4,	32,	97},
	Count			= 1,
	Cx_pil			= 15.6 / 4096,
	ejectVelocity	= 4,
	ejectPitchRate	= 0,
	Picture			= "kh31p.png",
	displayName		= _("Kh-31P (AS-17 Krypton) - 600kg, ARM, IN & Pas Rdr"),
	NatoName		= "(AS-17)",
	Weight			= 600,
	Elements		= {{
		ShapeName	= "X-31",
		Position	= {0.245, 0, 0}
	}},
})

local APKWS_Variants = {}

-- Hydra 70 with APKWS (AGR-20A) laser guidance kit, M151 HE DP warhead --
local AGR_20A =
{
	category		= CAT_MISSILES,
	name			= "AGR_20A",
	user_name		= ("%s APKWS"):format(_("Hydra 70 M151 HE")),
	display_name_short = "APKWS",
	scheme			= "APKWS",
	class_name		= "wAmmunitionLaserHoming",
	model			= "AGR_20",
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	
	mass			= 15,
	Escort			= 1,
	Head_Type		= 4,
	sigma			= {1, 1, 1},
	H_max			= 5000.0,
	H_min			= 1.0,
	Diam			= 70.0,
	Cx_pil			= 0.00244140625,
	D_max			= 5000.0,
	D_min			= 1000.0,
	Head_Form		= 1,
	Life_Time		= 90.0,
	Nr_max			= 25,
	v_min			= 140.0,
	v_mid			= 350.0,
	Mach_max		= 3.0,
	t_b				= 0.0,
	t_acc			= 0.0,
	t_marsh			= 1.1,
	Range_max		= 5000.0,
	H_min_t			= 15.0,
	Fi_start		= 0.4,
	Fi_rak			= 3.14152,
	Fi_excort		= 1.05,
	Fi_search		= 0.7,
	OmViz_max		= 0.35,
	exhaust			= {0.78, 0.78, 0.78, 0.3};
	X_back			= -2.0,
	Y_back			= -0.0,
	Z_back			= 0.0, -- -0.1,
	Reflection		= 0.01,
	KillDistance	= 0.0,
	M				= 15,
	
	warhead		= predefined_warhead("HYDRA_70_M151"),
	
	shape_table_data =
	{
		{
			name  = "AGR_20A";
			file  = "AGR_20";
			life  = 1;
			fire  = { 0, 1};
			username = _("APKWS"),
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	march = {
		fuel_mass   			= 3.175,
		impulse     			= 210,
		boost_time  			= 0,
		work_time   			= 1.1,
		boost_factor			= 1,
		nozzle_position 	    = {{-0.95, 0, 0}},
		nozzle_orientationXYZ   = {{0, 0, 0}},
		tail_width  			= 0.052,
		boost_tail  			= 1,
		work_tail   			= 1,
		smoke_color				= {0.5, 0.474, 0.443},
		smoke_transparency		= 0.5,
		custom_smoke_dissipation_factor		= 0.2,		
	},

	fm = {
		mass        = 15,  
		caliber     = 0.07, 
		cx_coeff    = {1, 1.5, 0.68, 0.7, 1.75},
		L           = 1.81,
		I           = 1 / 12 * 15 * 1.81 * 1.81,
		Ma          = 0.84,
		Mw          = 3.5,
		shapeName   = "AGR_20",
		wind_sigma	= 5.0,
		wind_time	= 1.1,
		dCydA		= {0.11, 0.11},
		A			= 0.36,
		Sw			= 0.04,
		maxAoa		= math.rad(8),		
		finsTau		= 0.1,
		Mx0			= 0.2,
		Ma_x		= 1.8,
		Mw_x		= 1.12,
		I_x			= 1.01,
	},
	
	seeker = {
		delay				= 1.1,
		FOV					= math.rad(40),
		max_seeker_range	= 13000,
	},

	autopilot = {
		delay				= 0.9,
		op_time				= 45,
		dV_dt				= 20,
		Knav				= 12,
		Tf					= 0.2,
		Kd					= 150,
		Kdx					= 0.2,
		Kix					= 0.8,
		gload_limit			= 10,
		fins_limit			= math.rad(20),
		fins_limit_x		= math.rad(10),
	},
	
	
	properties =
	{
		targeting_data = 
		{
			fm_type = 2,
		},
	},

	settings = Get_LGU_GUISettings_Preset("WGU59")
}
declare_weapon(AGR_20A)

-- Hydra 70 with APKWS (AGR-20A) laser guidance kit, M282 HEI MPP warhead --
local AGR_20_M282 =
{
	category		= CAT_MISSILES,
	name			= "AGR_20_M282",
	user_name		= ("%s APKWS"):format(_("Hydra 70 M282 MPP")),
	display_name_short = "APKWS",
	scheme			= "APKWS",
	class_name		= "wAmmunitionLaserHoming",
	model			= "AGR_20",
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	
	mass			= 17,
	Escort			= 1,
	Head_Type		= 4,
	sigma			= {1, 1, 1},
	H_max			= 5000.0,
	H_min			= 1.0,
	Diam			= 70.0,
	Cx_pil			= 0.00244140625,
	D_max			= 5000.0,
	D_min			= 1000.0,
	Head_Form		= 1,
	Life_Time		= 90.0,
	Nr_max			= 25,
	v_min			= 140.0,
	v_mid			= 350.0,
	Mach_max		= 3.0,
	t_b				= 0.0,
	t_acc			= 0.0,
	t_marsh			= 1.1,
	Range_max		= 5000.0,
	H_min_t			= 15.0,
	Fi_start		= 0.4,
	Fi_rak			= 3.14152,
	Fi_excort		= 1.05,
	Fi_search		= 0.7,
	OmViz_max		= 0.35,
	exhaust			= {0.78, 0.78, 0.78, 0.3};
	X_back			= -2.0,
	Y_back			= -0.0,
	Z_back			= 0.0,
	Reflection		= 0.01,
	KillDistance	= 0.0,
	M				= 15,
	
	warhead		= predefined_warhead("HYDRA_70_M282"),
	
	shape_table_data =
	{
		{
			name  = "AGR_20_M282";
			file  = "AGR_20";
			life  = 1;
			fire  = { 0, 1};
			username = _("APKWS M282"),
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	march = {
		fuel_mass   			= 3.175,
		impulse     			= 210,
		boost_time  			= 0,
		work_time   			= 1.1,
		boost_factor			= 1,
		nozzle_position 	    = {{-0.95, 0, 0}},
		nozzle_orientationXYZ   = {{0, 0, 0}},
		tail_width  			= 0.052,
		boost_tail  			= 1,
		work_tail   			= 1,
		smoke_color				= {0.5, 0.474, 0.443},
		smoke_transparency		= 0.5,
		custom_smoke_dissipation_factor		= 0.2,		
	},

	fm = {
		mass        = 17,  
		caliber     = 0.07, 
		cx_coeff    = {1, 1.5, 0.68, 0.7, 1.75},
		L           = 1.81,
		I           = 1 / 12 * 15 * 1.81 * 1.81,
		Ma          = 0.84,
		Mw          = 3.5,
		shapeName   = "AGR_20",
		wind_sigma	= 5.0,
		wind_time	= 1.1,
		dCydA		= {0.11, 0.11},
		A			= 0.36,
		Sw			= 0.04,
		maxAoa		= math.rad(8),		
		finsTau		= 0.1,
		Mx0			= 0.2,
		Ma_x		= 1.8,
		Mw_x		= 1.12,
		I_x			= 1.01,
	},
	
	seeker = {
		delay				= 1.1,
		FOV					= math.rad(40),
		max_seeker_range	= 13000,
	},

	autopilot = {
		delay				= 0.9,
		op_time				= 45,
		dV_dt				= 20,
		Knav				= 12,
		Tf					= 0.2,
		Kd					= 150,
		Kdx					= 0.2,
		Kix					= 0.8,
		gload_limit			= 10,
		fins_limit			= math.rad(20),
		fins_limit_x		= math.rad(10),
	},
	
	
	properties =
	{
		targeting_data = 
		{
			fm_type = 2,
		},
	},

	settings = Get_LGU_GUISettings_Preset("WGU59")
}
declare_weapon(AGR_20_M282)

APKWS_Variants["AGR_20A"] = AGR_20A
APKWS_Variants["AGR_20_M282"] = AGR_20_M282

--[[ --? Deprecated, superseded by BatchDeclareLoadout

local function lau_131_elements_connector(adapter,elem,count)
	local dest = {{ ShapeName	= adapter, IsAdapter = true}}
	for i = 1, count do
		dest[#dest + 1] = {ShapeName = elem, connector_name = string.format("tube_%02d",i) }
	end
	return dest
end

declare_loadout({
	category 			= CAT_ROCKETS,
	CLSID	 			= "{LAU-131 - 7 AGR-20A}",
	Picture				= "LAU131.png",
	--PictureBlendColor	= "0xffffffff",
	Cx_pil				= 0.00146484375,
	--displayName		= _("LAU-131 - 7 2.75' AGR-20A (HE)"),
	displayName			= _("LAU-131 pod - 7 x 2.75\" Hydra, Laser Guided Rkts M151, HE APKWS"),
	Count				= 7,
	Weight				= 29.5 + 7*15,
	wsTypeOfWeapon		= AGR_20A.wsTypeOfWeapon,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	Elements			= lau_131_elements_connector("LAU-131","AGR_20", 7)
})

declare_loadout({
	category 			= CAT_ROCKETS,
	CLSID	 			= "{LAU-131x3 - 7 AGR-20A}",
	Picture				= "LAU131.png",
	Cx_pil				= 0.00244140625,
	--displayName		= _("LAU-131*3 - 7 2.75' AGR-20A (HE)"),
	displayName			= _("BRU-42 with 3 x LAU-131 pods - 7 x 2.75\" Hydra, Laser Guided Rkts M151, HE APKWS"),
	Count				= 21,
	Weight				= 50.80 + 3*(29.5 +7*15),
	wsTypeOfWeapon		= AGR_20A.wsTypeOfWeapon,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	Elements			= lau_131_elements_connector("BRU-42_LS_(LAU-131)","AGR_20", 21),
})

declare_loadout({
	category 			= CAT_ROCKETS,
	CLSID	 			= "{LAU-131 - 7 AGR-20 M282}",
	Picture				= "LAU131.png",
	--PictureBlendColor	= "0xffffffff",
	Cx_pil				= 0.00146484375,
	--displayName			= _("LAU-131 - 7 2.75' AGR-20 M282"),
	displayName			= _("LAU-131 pod - 7 x 2.75\" Hydra, Laser Guided Rkts M282, MPP APKWS"),
	Count				= 7,
	Weight				= 29.5 + 7*17,
	wsTypeOfWeapon		= AGR_20_M282.wsTypeOfWeapon,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	Elements			= lau_131_elements_connector("LAU-131","AGR_20", 7)
})

declare_loadout({
	category 			= CAT_ROCKETS,
	CLSID	 			= "{LAU-131x3 - 7 AGR-20 M282}",
	Picture				= "LAU131.png",
	Cx_pil				= 0.00244140625,
	--displayName			= _("LAU-131*3 - 7 2.75' AGR-20 M282"),
	displayName			= _("BRU-42 with 3 x LAU-131 pods - 7 x 2.75\" Hydra, Laser Guided Rkts M282, MPP APKWS"),
	Count				= 21,
	Weight				= 50.80 + 3*(29.5 +7*17),
	wsTypeOfWeapon		= AGR_20_M282.wsTypeOfWeapon,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	Elements			= lau_131_elements_connector("BRU-42_LS_(LAU-131)","AGR_20", 21),
})

local agr20_lau_data =
{
	["LAU-131_AGR-20_M151"] = {name = "LAU-131 pod - 7 x 2.75\" Hydra, Laser Guided Rkts M151, HE APKWS", 	payload_CLSID = "{LAU-131 - 7 AGR-20A}", 	mass = 134.5, mass_empty = 29.5, wsType = AGR_20A.wsTypeOfWeapon, 		Cx = 0.00146484375, picture = "LAU131.png"},
	["LAU-131_AGR-20_M282"] = {name = "LAU-131 pod - 7 x 2.75\" Hydra, Laser Guided Rkts M282, MPP APKWS", 	payload_CLSID = "{LAU-131 - 7 AGR-20 M282}",mass = 148.5, mass_empty = 29.5, wsType = AGR_20_M282.wsTypeOfWeapon, 	Cx = 0.00146484375, picture = "LAU131.png"},
}

local function bru_42_ls_2x_lau_131(clsid,element,isleft)
	local lau_variant = agr20_lau_data[element] or agr20_lau_data["LAU-131_AGR-20_M151"]
	local ret = {
		category			=	CAT_ROCKETS,
		CLSID				=	clsid,
		Picture				=	lau_variant.picture,
		wsTypeOfWeapon		=	lau_variant.wsType,
		attribute			=	{4,	7,	32,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	0.0005,
		Elements 			= 	{}
	}
	
	ret.Elements[#ret.Elements + 1] = { ShapeName	= "BRU-42_LS", IsAdapter  =   true}
	
	if isleft then	
		ret.Elements[#ret.Elements + 1] = {payload_CLSID = lau_variant.payload_CLSID, connector_name =	"Point03"}
	else
		ret.Elements[#ret.Elements + 1] = {payload_CLSID = lau_variant.payload_CLSID, connector_name =	"Point02"}	
	end
	ret.Elements[#ret.Elements + 1] = {payload_CLSID = lau_variant.payload_CLSID, connector_name =	"Point01"}

	local sz = #ret.Elements - 1
	ret.Count  = sz
	ret.Weight_Empty = 56.25 + sz * lau_variant.mass_empty
	ret.Weight = 56.25 + sz * lau_variant.mass
	ret.Cx_pil = ret.Cx_pil + sz * lau_variant.Cx
	ret.displayName =	_("BRU-42 with "..sz.." x "..lau_variant.name)
	
	declare_loadout(ret)
end

bru_42_ls_2x_lau_131("{LAU-131x2 - 7 AGR-20 M282 L}", 	"LAU-131_AGR-20_M282", true)
bru_42_ls_2x_lau_131("{LAU-131x2 - 7 AGR-20 M282 R}", 	"LAU-131_AGR-20_M282", false)
bru_42_ls_2x_lau_131("{LAU-131x2 - 7 AGR-20A L}", 		"LAU-131_AGR-20_M151", true)
bru_42_ls_2x_lau_131("{LAU-131x2 - 7 AGR-20A R}", 		"LAU-131_AGR-20_M151", false)
]]

BatchDeclareLoadout(
	MLData.LAU131,
	{
		-- Individual LAU-131s
		["{LAU-131 - 7 AGR-20A}"]				= { weaponResName = "AGR_20A",		attribute = { wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER }, },
		["{LAU-131 - 7 AGR-20 M282}"]			= { weaponResName = "AGR_20_M282",	attribute = { wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER }, },
		-- LAU-131s on BRU-42 - triple
		["{LAU-131x3 - 7 AGR-20A}"]				= { weaponResName = "AGR_20A",		multiRackParams = { MER = LauncherData.BRU42, elemCLSID = "{LAU-131 - 7 AGR-20A}" },		attribute = { wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER }, },
		["{LAU-131x3 - 7 AGR-20 M282}"]			= { weaponResName = "AGR_20_M282",	multiRackParams = { MER = LauncherData.BRU42, elemCLSID = "{LAU-131 - 7 AGR-20 M282}" },	attribute = { wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER }, },
		-- LAU-131s on BRU-42 - double, right
		["{LAU-131x2 - 7 AGR-20A R}"]			= { weaponResName = "AGR_20A",		multiRackParams = { MER = LauncherData.BRU42, elemCLSID = "{LAU-131 - 7 AGR-20A}", elemCount = 2 } },
		["{LAU-131x2 - 7 AGR-20 M282 R}"]		= { weaponResName = "AGR_20_M282",	multiRackParams = { MER = LauncherData.BRU42, elemCLSID = "{LAU-131 - 7 AGR-20 M282}", elemCount = 2 } },
		-- LAU-131s on BRU-42 - double, left
		["{LAU-131x2 - 7 AGR-20A L}"]			= { weaponResName = "AGR_20A",		multiRackParams = { MER = LauncherData.BRU42, elemCLSID = "{LAU-131 - 7 AGR-20A}", elemCount = 2, skipTable = { 2 } } },
		["{LAU-131x2 - 7 AGR-20 M282 L}"]		= { weaponResName = "AGR_20_M282",	multiRackParams = { MER = LauncherData.BRU42, elemCLSID = "{LAU-131 - 7 AGR-20 M282}", elemCount = 2, skipTable = { 2 } } },
	},
	APKWS_Variants
)

BatchDeclareLoadout(
	MLData.M260,
	{
		["{M260_APKWS_M151}"]					= { weaponResName = "AGR_20A" },
	},
	APKWS_Variants
)

local AGM_114K =
{
	category		= CAT_MISSILES,
	name			= "AGM_114K",
	display_name 	= _('AGM-114K Hellfire'),
	display_name_short = "AGM-114",
	user_name		= _("AGM-114K"),
	scheme			= "AGM-114K",
	class_name		= "wAmmunitionLaserHoming",
	model			= "agm-114K",
	
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,AGM_114K},
	
	shape_table_data =
	{
		{
			file  = "agm-114K";
			life  = 1;
			fire  = {0, 1};
			name  	 = "AGM-114K";
			username = "AGM-114K";
			index 	 = AGM_114K,
		},
	},
	
    Escort = 1,
    Head_Type = 4,
	sigma = {4, 4, 4},
	mass = 45.3,
    M = 45.3,
    H_max = 3600.0,
    H_min = -1,
    Diam = 178.0,
    Cx_pil = 2,
    D_max = 9000.0,
    D_min = 500.0,
    Head_Form = 1,
    Life_Time = 45.0,
	Nr_max = 15,
	v_min = 0,
	v_mid = 250.0,
	Mach_max = 1.4,
	t_b = 0.0,
	t_acc = 2.5,
	t_marsh = 0.0,
	Range_max = 9000.0,
	H_min_t = 0.0,
	Fi_start = 0.44,
	Fi_rak = 3.14152,
	Fi_excort = 0.8,
	Fi_search = 99.9,
	OmViz_max = 99.9,
	exhaust = {0.9, 0.9, 0.85, 0.1};
	X_back = -0.88,
	Y_back = 0.0,
	Z_back = 0.0,
	Reflection = 0.03,
	KillDistance = 0.0,
	
	warhead		= predefined_warhead("AGM_114K"),
	warhead_air = predefined_warhead("AGM_114K"),

	controller = {
		boost_start = 0,
		march_start = 0,
	},
	
	boost = {
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0.1,
		nozzle_position						= {{-1.9, 0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		nozzle_exit_area 					= 0.0132,
		tail_width							= 0.4,
		smoke_color							= {0.8, 0.8, 0.8},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,	
	},
	
	march = {
		impulse								= 228,
		fuel_mass							= 9.3,
		work_time							= 2.5,
		nozzle_position						= {{-0.88, 0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		nozzle_exit_area 					= 0.0132,
		tail_width							= 0.4,
		smoke_color							= {0.8, 0.8, 0.8},
		smoke_transparency					= 0.1,
		custom_smoke_dissipation_factor		= 0.2,
		smoke_opacity_type 					= 2,
	},
	
	fm = {
		mass				= 45.4,  
		caliber				= 0.178,  
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		tail_first			= 0,
		fins_part_val		= 0,
		rotated_fins_inp	= 0,
		delta_max			= math.rad(20),
		draw_fins_conv		= {math.rad(90),1,1},
		L					= 0.178,
		S					= 0.0248,
		Ix					= 0.24,
		Iy					= 9.8,
		Iz					= 9.8,
		
		Mxd					= 0.04 * 57.3,
		Mxw					= -15.8,

		table_scale	= 0.2,
		table_degree_values = 1,
	--	Mach	  | 0.0		0.2		0.4		0.6		0.8		1.0		1.2		1.4		1.6		1.8		2.0		2.2	  |
		Cx0 	= {	0.289,	0.289,	0.289,	0.289,	0.306,	0.542,	0.712,	0.751,	0.751,	0.736,	0.719,	0.706 },
		CxB 	= {	0.038,	0.038,	0.038,	0.038,	0.04,	0.126,	0.162,	0.154,	0.144,	0.132,	0.122,	0.114 },
		K1		= { 0.00041,0.00041,0.00041,0.00041,0.00041,0.00052,0.00044,0.00042,0.0004,0.0003,0.0002,0.00015 },
		K2		= {-0.00024,-0.00024,-0.00024,-0.00024,-0.00018,0.00005,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001 },
		Cya		= { 0.209,	0.209,	0.209,	0.209,	0.209,	0.244,	0.224,	0.205,	0.191,	0.178,	0.169,	0.161 },
		Cza		= { 0.209,	0.209,	0.209,	0.209,	0.209,	0.244,	0.224,	0.205,	0.191,	0.178,	0.169,	0.161 },
		Mya		= {-0.185,	-0.185,	-0.185,	-0.185,	-0.19,	-0.2,	-0.211,	-0.21,	-0.2,	-0.19,	-0.17,	-0.15 },
		Mza		= {-0.185,	-0.185,	-0.185,	-0.185,	-0.19,	-0.2,	-0.211,	-0.21,	-0.2,	-0.19,	-0.17,	-0.15 },
		Myw		= {-15.556,	-15.556,-15.556,-15.556,-16.321,-19.722,-19.702,-19.65,-19.515,-18.88,-17.748,-16.224 },
		Mzw		= {-15.556,	-15.556,-15.556,-15.556,-16.321,-19.722,-19.702,-19.65,-19.515,-18.88,-17.748,-16.224 },
		A1trim	= { 14.1,	14.1,	14.1,	14.1,	14.1,	15.1,	12.6,	10.8,	9.8,	9.1,	8.6,	8.3 },
		A2trim	= { 14.1,	14.1,	14.1,	14.1,	14.1,	15.1,	12.6,	10.8,	9.8,	9.1,	8.6,	8.3 },
		
		model_roll = math.rad(45),
		fins_stall = 0,
	},
	
	sensor = {
		FOV					= math.rad(8),
		max_seeker_range	= 16000,
	},
	
	gimbal = {
		delay				= 0,
		op_time				= 95,
		pitch_max			= math.rad(30),
		yaw_max				= math.rad(30),
		max_tracking_rate	= math.rad(15),
		tracking_gain		= 50,
	},

	autopilot = {
		delay				= 0.2,
		op_time				= 45,
		dV_dt				= 25,
		Knav				= 4,
		Kbias				= 2,
		Kloft				= 2,
		Kloss				= 2,
		Tf					= 0.2,
		Kd					= 200,
		Ki					= 2,
		Kdx					= 0.2,
		Kix					= 0.8,
		null_roll			= math.rad(45),
		gload_limit			= 16,
		fins_limit			= math.rad(15),
		fins_limit_x		= math.rad(10),
	},
	
	actuator = {
		Tf					= 0.005,
		D					= 250.0,
		T1					= 0.002,
		T2					= 0.006,
		max_omega			= math.rad(400),
		max_delta			= math.rad(20),
		fin_stall			= 1,
		sim_count			= 4,
	},
}
declare_weapon(AGM_114K)

local AGM_114L =
{
	category		= CAT_MISSILES,
	name			= "AGM_114",
	display_name 	= _('AGM-114L Longbow'),
	user_name		= _("AGM-114L"),
	display_name_short = "AGM-114",
	scheme			= "AGM-114LS",
	class_name		= "wAmmunitionSelfHoming",
	model			= "agm-114l",
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,AGM_114},
	
	shape_table_data =
	{
		{
			file  = "agm-114l";
			life  = 1;
			fire  = {0, 1};
			name  	 = "AGM-114L";
			username = "AGM-114L";
			index 	 = AGM_114,
		},
	},
	
	Escort = 0,
	Head_Type = 2,
	sigma = {4, 4, 4},
	mass = 49,
	M = 49,
	H_max = 3800.0,
	H_min = -1,
	Diam = 178.0,
	Cx_pil = 2,
	D_max = 8000.0,
	D_min = 500.0,
	Head_Form = 1,
	Life_Time = 45.0,
	Nr_max = 16,
	v_min = 0,
	v_mid = 250.0,
	Mach_max = 1.4,
	t_b = 0.0,
	t_acc = 2.5,
	t_marsh = 0.0,
	Range_max = 8000.0,
	H_min_t = 0.0,
	Fi_start = 0.44,
	Fi_rak = 3.14152,
	Fi_excort = 0.44,
	Fi_search = 99.9,
	OmViz_max = 99.9,
	exhaust = {0.9, 0.9, 0.85, 0.1};
	X_back = -0.95,
	Y_back = 0.0,
	Z_back = 0.0,
	Reflection = 0.03,
	KillDistance = 0.0,
	
	warhead		= predefined_warhead("AGM_114K"),
	warhead_air = predefined_warhead("AGM_114K"),
	
	controller = {
		boost_start = 0,
		march_start = 0,
	},
	
	boost = {
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0.1,
		nozzle_position						= {{-1.0, 0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		nozzle_exit_area 					= 0.0132,
		tail_width							= 0.4,
		smoke_color							= {0.8, 0.8, 0.8},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,	
	},
	
	march = {
		impulse								= 228,
		fuel_mass							= 9.3,
		work_time							= 2.5,
		nozzle_position						= {{-0.88, 0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		nozzle_exit_area 					= 0.0132,
		tail_width							= 0.4,
		smoke_color							= {0.8, 0.8, 0.8},
		smoke_transparency					= 0.1,
		custom_smoke_dissipation_factor		= 0.2,
		smoke_opacity_type 					= 2,
	},
	
	fm = {
		mass				= 49.0,  
		caliber				= 0.178,  
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		tail_first			= 0,
		fins_part_val		= 0,
		rotated_fins_inp	= 0,
		delta_max			= math.rad(20),
		draw_fins_conv		= {math.rad(90),1,1},
		L					= 0.178,
		S					= 0.0248,
		Ix					= 0.24,
		Iy					= 9.8,
		Iz					= 9.8,
		
		Mxd					= 0.04 * 57.3,
		Mxw					= -15.8,

		table_scale	= 0.2,
		table_degree_values = 1,
	--	Mach	  | 0.0		0.2		0.4		0.6		0.8		1.0		1.2		1.4		1.6		1.8		2.0		2.2	  |
		Cx0 	= {	0.316,	0.316,	0.316,	0.316,	0.368,	0.776,	0.992,	1.043,	1.065,	1.06,	1.054,	1.048 },
		CxB 	= {	0.038,	0.038,	0.038,	0.038,	0.04,	0.126,	0.162,	0.154,	0.144,	0.132,	0.122,	0.114 },
		K1		= { 0.00041,0.00041,0.00041,0.00041,0.00041,0.00052,0.00044,0.00042,0.0004,0.0003,0.0002,0.00015 },
		K2		= {-0.00024,-0.00024,-0.00024,-0.00024,-0.00018,0.00005,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001 },
		Cya		= { 0.209,	0.209,	0.209,	0.209,	0.209,	0.244,	0.224,	0.205,	0.191,	0.178,	0.169,	0.161 },
		Cza		= { 0.209,	0.209,	0.209,	0.209,	0.209,	0.244,	0.224,	0.205,	0.191,	0.178,	0.169,	0.161 },
		Mya		= {-0.185,	-0.185,	-0.185,	-0.185,	-0.19,	-0.2,	-0.211,	-0.21,	-0.2,	-0.19,	-0.17,	-0.15 },
		Mza		= {-0.185,	-0.185,	-0.185,	-0.185,	-0.19,	-0.2,	-0.211,	-0.21,	-0.2,	-0.19,	-0.17,	-0.15 },
		Myw		= {-15.556,	-15.556,-15.556,-15.556,-16.321,-19.722,-19.702,-19.65,-19.515,-18.88,-17.748,-16.224 },
		Mzw		= {-15.556,	-15.556,-15.556,-15.556,-16.321,-19.722,-19.702,-19.65,-19.515,-18.88,-17.748,-16.224 },
		A1trim	= { 14.1,	14.1,	14.1,	14.1,	14.1,	15.1,	12.6,	10.8,	9.8,	9.1,	8.6,	8.3 },
		A2trim	= { 14.1,	14.1,	14.1,	14.1,	14.1,	15.1,	12.6,	10.8,	9.8,	9.1,	8.6,	8.3 },
		
		model_roll = math.rad(45),
		fins_stall = 0,
	},
	
	sensor = {
		op_time	= 50,
		FOV		= math.rad(6),
		aim_sigma = 0.7,
	},
	
	gimbal = {
		delay				= 0,
		op_time				= 95,
		pitch_max			= math.rad(30),
		yaw_max				= math.rad(30),
		max_tracking_rate	= math.rad(20),
		mount_roll_angle	= math.rad(-45),
		tracking_gain		= 50,
	},

	autopilot = {
		delay				= 0.2,
		op_time				= 45,
		Ka					= 20,
		Tm					= 300,
		Tc					= 0.05,
		Kd					= 120,
		Krd					= 0.2,
		Kra					= 0.8,
		null_roll			= math.rad(0),
		gload_limit			= 16,
		omega_limit			= math.rad(90),
		fins_limit			= math.rad(18),
		fins_limit_x		= math.rad(10),

	},
	
	actuator = {
		Tf					= 0.005,
		D					= 250.0,
		T1					= 0.002,
		T2					= 0.006,
		max_omega			= math.rad(400),
		max_delta			= math.rad(20),
		fin_stall			= 1,
		sim_count			= 4,
	},
}
declare_weapon(AGM_114L)

declare_loadout({
	CLSID			= "{ee368869-c35a-486a-afe7-284beb7c5d52}",--AGM-114K
	category		= CAT_MISSILES,
	attribute		= AGM_114K.wsTypeOfWeapon,
	Count			= 1,
	Cx_pil			= 0.00013,
	Picture			= "agm114.png",
	displayName		= _("AGM-114K Hellfire"),
	Weight			= 45.3,
	Elements		= {{
		ShapeName	= "agm-114k",
	}},
})

declare_loadout({
	CLSID			= "{AGM_114L}",
	category		= CAT_MISSILES,
	attribute		= AGM_114L.wsTypeOfWeapon,
	Count			= 1,
	Cx_pil			= 0.00014,
	Picture			= "agm114.png",
	displayName		= _("AGM-114L Longbow"),
	Weight			= 49,
	Elements		= {{
		ShapeName	= "agm-114l",
	}},
})

local AGM_114K_CLSID = "{ee368869-c35a-486a-afe7-284beb7c5d52}"
local function createMixedM299(fillParams)
	local result = ContainerWithSubshapes(MLData.M299.modelFileName)

	for clsid, connParams in pairs(fillParams) do
		local newElements = ContainerWithSubshapes(nil, clsid, connParams.count, MLData.M299.connNamePattern, connParams.skipConns, true)

		for _, newElement in pairs(newElements) do
			table.insert(result, newElement)
		end
	end

	local function ascComparator(a, b)
		if a.connector_name and b.connector_name then
			return a.connector_name < b.connector_name
		end

		return false
	end

	table.sort(result, ascComparator)

	return result
end

BatchDeclareLoadout(
	MLData.M299,
	{
		----------------AGM-114K------------------
		["{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}"]	= {
			displayName		= _("M299 - 4 x AGM-114K Hellfire"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114K", 4, MLData.M299.connNamePattern),
			Picture			= "agm114.png",
			singleWpnMass	= 44.9,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K",
		},
		["{M299_3xAGM_114K_OUTBOARD_PORT}"]			= {
			displayName		= _("M299 - 3 x AGM-114K Hellfire, Port"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114K", 3, MLData.M299.connNamePattern),
			Picture			= "agm114.png",
			singleWpnMass	= 44.9,
			wpnCount		= 3,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K",
		},
		["{M299_3xAGM_114K_OUTBOARD_STARBOARD}"]	= {
			displayName		= _("M299 - 3 x AGM-114K Hellfire, Starboard"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114K", 3, MLData.M299.connNamePattern, {2}),
			Picture			= "agm114.png",
			singleWpnMass	= 44.9,
			wpnCount		= 3,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K",
		},
		["{M299_2xAGM_114K}"] = {
			displayName		= _("M299 - 2 x AGM-114K Hellfire"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114K", 2, MLData.M299.connNamePattern, {2}),
			Picture			= "agm114.png",
			singleWpnMass	= 44.9,
			wpnCount		= 2,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K",
		},
		["{M299_1xAGM_114K_OUTBOARD_PORT}"]			= {
			displayName		= _("M299 - 1 x AGM-114K Hellfire, Port"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114K", 1, MLData.M299.connNamePattern),
			Picture			= "agm114.png",
			singleWpnMass	= 44.9,
			wpnCount		= 1,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K",
		},
		["{M299_1xAGM_114K_OUTBOARD_STARBOARD}"]	= {
			displayName		= _("M299 - 1 x AGM-114K Hellfire, Starboard"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114K", 1, MLData.M299.connNamePattern, {1, 2}),
			Picture			= "agm114.png",
			singleWpnMass	= 44.9,
			wpnCount		= 1,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K",
		},
		----------------AGM-114L------------------
		["{M299_4xAGM_114L}"]	= {
			displayName		= _("M299 - 4 x AGM-114L Hellfire"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114", 4, MLData.M299.connNamePattern),
			Picture			= "agm114L.png",
			singleWpnMass	= 49,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114",
		},
		["{M299_3xAGM_114L_OUTBOARD_PORT}"]			= {
			displayName		= _("M299 - 3 x AGM-114L Hellfire, Port"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114", 3, MLData.M299.connNamePattern),
			Picture			= "agm114L.png",
			singleWpnMass	= 49,
			wpnCount		= 3,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114",
		},
		["{M299_3xAGM_114L_OUTBOARD_STARBOARD}"]	= {
			displayName		= _("M299 - 3 x AGM-114L Hellfire, Starboard"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114", 3, MLData.M299.connNamePattern, {2}),
			Picture			= "agm114L.png",
			singleWpnMass	= 49,
			wpnCount		= 3,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114",
		},
		["{M299_2xAGM_114L}"] = {
			displayName		= _("M299 - 2 x AGM-114L Hellfire"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114", 2, MLData.M299.connNamePattern, {2}),
			Picture			= "agm114L.png",
			singleWpnMass	= 49,
			wpnCount		= 2,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114",
		},
		["{M299_1xAGM_114L_OUTBOARD_PORT}"]			= {
			displayName		= _("M299 - 1 x AGM-114L Hellfire, Port"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114", 1, MLData.M299.connNamePattern),
			Picture			= "agm114L.png",
			singleWpnMass	= 49,
			wpnCount		= 1,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114",
		},
		["{M299_1xAGM_114L_OUTBOARD_STARBOARD}"]	= {
			displayName		= _("M299 - 1 x AGM-114L Hellfire, Starboard"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName, "AGM-114", 1, MLData.M299.connNamePattern, {1, 2}),
			Picture			= "agm114L.png",
			singleWpnMass	= 49,
			wpnCount		= 1,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114",
		},
		----------------AGM-114K/L Mixed------------------
		["{M299_1xAGM_114K_3xAGM_114L_PRT}"] = {
			displayName		= _("M299 - 1 x AGM-114K, 3 x AGM-114L Hellfire, Port"),
			Picture			= "agm114KLmix.png",
			singleWpnMass	= (AGM_114K.fm.mass + 3 * AGM_114L.fm.mass) / 4,
			wpnCount		= 4,
			Elements		= createMixedM299({[AGM_114K_CLSID] = { count = 1, skipConns = {1, 2, 3} }, ["{AGM_114L}"] = { count = 3 } }),
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K"
		},
		["{M299_1xAGM_114K_3xAGM_114L_STRBRD}"] = {
			displayName		= _("M299 - 1 x AGM-114K, 3 x AGM-114L Hellfire, Starboard"),
			Picture			= "agm114KLmix.png",
			singleWpnMass	= (AGM_114K.fm.mass + 3 * AGM_114L.fm.mass) / 4,
			wpnCount		= 4,
			Elements		= createMixedM299({[AGM_114K_CLSID] = { count = 1, skipConns = {1} }, ["{AGM_114L}"] = { count = 3, skipConns = {2} } }),
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K"
		},
		["{M299_2xAGM_114K_2xAGM_114L}"] = {
			displayName		= _("M299 - 2 x AGM-114K, 2 x AGM-114L Hellfire"),
			Picture			= "agm114KLmix.png",
			singleWpnMass	= (2 * AGM_114K.fm.mass + 2 * AGM_114L.fm.mass) / 4,
			wpnCount		= 4,
			Elements		= createMixedM299({[AGM_114K_CLSID] = { count = 2, skipConns = {1, 3} }, ["{AGM_114L}"] = { count = 2, skipConns = {2} } }),
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K"
		},
		["{M299_3xAGM_114K_1xAGM_114L_STRBRD}"] = {
			displayName		= _("M299 - 3 x AGM-114K, 1 x AGM-114L Hellfire, Starboard"),
			Picture			= "agm114KLmix.png",
			singleWpnMass	= (3 * AGM_114K.fm.mass + AGM_114L.fm.mass) / 4,
			wpnCount		= 4,
			Elements		= createMixedM299({[AGM_114K_CLSID] = { count = 3, skipConns = {3} }, ["{AGM_114L}"] = { count = 1, skipConns = {1, 2} } }),
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K"
		},
		["{M299_3xAGM_114K_1xAGM_114L_PRT}"] = {
			displayName		= _("M299 - 3 x AGM-114K, 1 x AGM-114L Hellfire, Port"),
			Picture			= "agm114KLmix.png",
			singleWpnMass	= (3 * AGM_114K.fm.mass + AGM_114L.fm.mass) / 4,
			wpnCount		= 4,
			Elements		= createMixedM299({[AGM_114K_CLSID] = { count = 3, skipConns = {1} }, ["{AGM_114L}"] = { count = 1 } }),
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K"
		},
		----------------M299----------------
		["{M299_EMPTY}"] = {
			displayName		= _("M299 - Empty Launcher"),
			Elements		= ContainerWithSubshapes(MLData.M299.modelFileName),
			Picture			= "M299.png",
			shape_table_data= {{ file = "M299", username = "M299", index = WSTYPE_PLACEHOLDER, }},
			wpnCount		= 0,
			wsTypeOfWeapon	= "weapons.missiles.AGM_114K",
		}
	}
)

AT_6 = {
	category		= CAT_MISSILES,
	wsTypeOfWeapon	= {4, 4, 8, 48},
	name			= "AT_6",
	user_name		= _("9M114 Shturm (AT-6 Spiral)"),
	
	scheme			= "shturm_new",
	class_name		= "wAmmunitionVikhr",
	model			= "9M114",
	display_name_short = _("9M114"),

	Escort			= 1,
	Head_Type		= 7,
	sigma			= {4, 4, 4},
	M				= 35.4,
	H_max			= 4000,
	H_min			= -1,
	Diam			= 130,
	Cx_pil			= 0,
	D_max			= 6000,
	D_min			= 800,
	Head_Form		= 1,
	Life_Time		= 30,
	Nr_max			= 1.2,
	v_min			= 170,
	v_mid			= 300,
	Mach_max		= 1.8,
	t_b				= 0,
	t_acc			= 5,
	t_marsh			= 0,
	Range_max		= 6000,
	H_min_t			= 0,
	Fi_start		= 0.1,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.4,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= -0.922,
	Y_back			= 0,
	Z_back			= 0,
	Reflection		= 0.03,
	KillDistance	= 0,

	booster = {
		impulse							= 220,
		fuel_mass						= 1,
		work_time						= 0.05,
		nozzle_position					= {{-0.92, 0, 0}},
		tail_width						= 0.13,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.8,
		custom_smoke_dissipation_factor	= 0.5,
	},

	march = {
		impulse							= 240,
		fuel_mass						= 6.46, -- 7600N for 2s
		work_time						= 2,
		nozzle_position					= {{-0.515, 0, 0.07},{-0.515, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0},{0, 0.2, 0}},
		tail_width						= 0.06,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	march2 = {
		impulse							= 250,
		fuel_mass						= 2.94, -- 3600N for 3s
		work_time						= 3,
		nozzle_position					= {{-0.515, 0, 0.07},{-0.515, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0},{0, 0.2, 0}},
		tail_width						= 0.06,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	march_smoke = {
		impulse							= 0.5,
		fuel_mass						= 0.6,
		work_time						= 0.5,
		nozzle_position					= {{-0.515, 0, 0.07},{-0.515, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0.15},{0, 0.2, 0}},
		tail_width						= 0.13,
		smoke_color						= {0.1, 0.1, 0.1},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	spiral_nav = {
		t_cone_near_rad			= 1000,
		def_cone_max_dist		= 6500,
		def_cone_near_rad		= 1000,
		def_cone_near_rad_st	= 0,
		def_cone_time_stab_rad	= 0,
		gb_angle				= 0.0036,
		gb_min_dist				= 3200,
		gb_use_time				= 5.3,
		gb_max_retW				= 0.4,
		gb_ret_Kp				= 1.1,
	},

	autopilot = {
		Kp					= 0.062,
		Ki					= 0.056,
		Kd					= 0.036,
		max_ctrl_angle		= 1.15,
		delay				= 0.7,
		op_time				= 18,
		fins_discreet		= 0.08,
		no_ctrl_center_ang	= 0.00002,
		fins_limit			= 1,

		self_destruct_maneuver			= 1,
		self_destruct_maneuver_cmd_y	= 0.3,
		self_destruct_maneuver_cmd_z	= 0.6,
		self_destruct_start_timer		= 18,
		self_destruct_command_timer		= 3,
		self_destruct_no_signal_lim		= 0.5,
	},


	fm = {
		mass		= 35.4,
		caliber		= 0.13,
		L			= 1.83,
		I			= 1 / 12 * 35.4 * 1.83 ^ 2,
		Ma			= 2,
		Mw			= 5,
		cx_coeff	= {1, 1.5, 1.2, 0.2, 1.3},
		Sw			= 0.12,
		dCydA		= {0.024, 0.018},
		A			= 0.6,
		maxAoa		= 0.2,
		finsTau		= 0.05,
		freq		= 4,
	},

	eng_err = {
		y_error				= 0,
		z_error				= 0.1,
		min_time_interval	= 0.1,
		max_time_interval	= 1,
	},

	fuze = {
		default_arm_delays = { 0.8 }
	},

	shape_table_data = {{
		name		= "AT_6",
		file		= "9M114",
		username	= _("AT-6"),
		index		= WSTYPE_PLACEHOLDER
	}},

	warhead		= predefined_warhead("AT_6"),
}
declare_weapon(AT_6)

Ataka_9M120 = {
	category		= CAT_MISSILES,
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Missile, wsType_AS_Missile, WSTYPE_PLACEHOLDER},
	name			= "Ataka_9M120",
	user_name		= _("9M120 Ataka (AT-9 Spiral-2)"),
	
	scheme			= "shturm_new",
	class_name		= "wAmmunitionVikhr",
	model			= "9M120T",
	display_name_short = _("9M120"),

	Escort			= 1,
	Head_Type		= 7,
	sigma			= {4, 4, 4},
	M				= 49.5,
	H_max			= 4000,
	H_min			= -1,
	Diam			= 130,
	Cx_pil			= 0,
	D_max			= 6000,
	D_min			= 800,
	Head_Form		= 1,
	Life_Time		= 30,
	Nr_max			= 1.2,
	v_min			= 170,
	v_mid			= 300,
	Mach_max		= 1.8,
	t_b				= 0,
	t_acc			= 5,
	t_marsh			= 0,
	Range_max		= 6000,
	H_min_t			= 0,
	Fi_start		= 0.1,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.4,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= -0.922,
	Y_back			= 0,
	Z_back			= 0,
	Reflection		= 0.03,
	KillDistance	= 0,

	manualWeaponFlag = 3,

	booster = {
		impulse							= 220,
		fuel_mass						= 1,
		work_time						= 0.05,
		nozzle_position					= {{-1.08, 0, 0}},
		tail_width						= 0.13,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.8,
		custom_smoke_dissipation_factor	= 0.5,
	},

	march = {
		impulse							= 240,
		fuel_mass						= 5.53, -- 6500N for 2s
		work_time						= 2,
		nozzle_position					= {{-0.685, 0, 0.07},{-0.685, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0},{0, 0.2, 0}},
		tail_width						= 0.06,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	march2 = {
		impulse							= 250,
		fuel_mass						= 4.29, -- 3500N for 3s
		work_time						= 3,
		nozzle_position					= {{-0.685, 0, 0.07},{-0.685, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0},{0, 0.2, 0}},
		tail_width						= 0.06,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	march_smoke = {
		impulse							= 0.5,
		fuel_mass						= 0.6,
		work_time						= 0.5,
		nozzle_position					= {{-0.685, 0, 0.07},{-0.685, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0.15},{0, 0.2, 0}},
		tail_width						= 0.13,
		smoke_color						= {0.1, 0.1, 0.1},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	spiral_nav = {
		t_cone_near_rad			= 1000,
		def_cone_max_dist		= 6500,
		def_cone_near_rad		= 1000,
		def_cone_near_rad_st	= 0,
		def_cone_time_stab_rad	= 0,
		gb_angle				= 0.0036,
		gb_min_dist				= 3200,
		gb_use_time				= 5.3,
		gb_max_retW				= 0.4,
		gb_ret_Kp				= 1.1,
	},

	autopilot = {
		Kp					= 0.062,
		Ki					= 0.056,
		Kd					= 0.036,
		max_ctrl_angle		= 1.15,
		delay				= 0.7,
		op_time				= 18,
		fins_discreet		= 0.08,
		no_ctrl_center_ang	= 0.00002,
		fins_limit			= 1,

		self_destruct_maneuver			= 1,
		self_destruct_maneuver_cmd_y	= 0.3,
		self_destruct_maneuver_cmd_z	= 0.6,
		self_destruct_start_timer		= 18,
		self_destruct_command_timer		= 3,
		self_destruct_no_signal_lim		= 0.5,
	},

	fm = {
		mass				= 42.5,
		caliber				= 0.13,
		L					= 1.83, -- 2.1 with leading charge deployed
		I					= 1 / 12 * 49.5 * 1.83 * 1.83,
		Ma					= 2,
		Mw					= 5,
		cx_coeff			= {1, 1.5, 1.2, 0.2, 1.3},
		Sw					= 0.12,
		dCydA				= {0.024, 0.018},
		A					= 0.6,
		maxAoa				= 0.2,
		finsTau				= 0.05,
		freq				= 4,
	},

	eng_err = {
		y_error				= 0,
		z_error				= 0.1,
		min_time_interval	= 0.1,
		max_time_interval	= 1,
	},

	fuze = {
		default_arm_delays = { 0.8 }
	},

	encyclopediaAnimation = {
		args = {
			[0] = 1.000000, --warhead extension
		},
	},

	shape_table_data = {{
		name		= _("9M120"),
		file		= "9M120T",
		username	= _("9M120"),
		index		= WSTYPE_PLACEHOLDER
	}},

	warhead		= predefined_warhead("9M120"),
}
declare_weapon(Ataka_9M120)

Ataka_9M120F = {
	category		= CAT_MISSILES,
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Missile, wsType_AS_Missile, WSTYPE_PLACEHOLDER},
	name			= "Ataka_9M120F",
	user_name		= _("9M120F Ataka (AT-9 Spiral-2)"),
	
	scheme			= "shturm_new",
	class_name		= "wAmmunitionVikhr",
	model			= "9M120F",
	display_name_short = _("9M120F"),

	Escort			= 1,
	Head_Type		= 7,
	sigma			= {4, 4, 4},
	M				= 49.5,
	H_max			= 4000,
	H_min			= -1,
	Diam			= 130,
	Cx_pil			= 0,
	D_max			= 6000,
	D_min			= 800,
	Head_Form		= 1,
	Life_Time		= 30,
	Nr_max			= 1.2,
	v_min			= 170,
	v_mid			= 300,
	Mach_max		= 1.8,
	t_b				= 0,
	t_acc			= 5,
	t_marsh			= 0,
	Range_max		= 6000,
	H_min_t			= 0,
	Fi_start		= 0.1,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.4,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= -0.922,
	Y_back			= 0,
	Z_back			= 0,
	Reflection		= 0.03,
	KillDistance	= 0,

	manualWeaponFlag = 3,

	booster = {
		impulse							= 220,
		fuel_mass						= 1,
		work_time						= 0.05,
		nozzle_position					= {{-1.08, 0, 0}},
		tail_width						= 0.13,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.8,
		custom_smoke_dissipation_factor	= 0.5,
	},

	march = {
		impulse							= 240,
		fuel_mass						= 5.53, -- 6500N for 2s
		work_time						= 2,
		nozzle_position					= {{-0.515, 0, 0.07},{-0.515, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0},{0, 0.2, 0}},
		tail_width						= 0.06,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	march2 = {
		impulse							= 250,
		fuel_mass						= 4.29, -- 3500N for 3s
		work_time						= 3,
		nozzle_position					= {{-0.515, 0, 0.07},{-0.515, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0},{0, 0.2, 0}},
		tail_width						= 0.06,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	march_smoke = {
		impulse							= 0.5,
		fuel_mass						= 0.6,
		work_time						= 0.5,
		nozzle_position					= {{-0.515, 0, 0.07},{-0.515, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0.15},{0, 0.2, 0}},
		tail_width						= 0.13,
		smoke_color						= {0.1, 0.1, 0.1},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	spiral_nav = {
		t_cone_near_rad			= 1000,
		def_cone_max_dist		= 6500,
		def_cone_near_rad		= 1000,
		def_cone_near_rad_st	= 0,
		def_cone_time_stab_rad	= 0,
		gb_angle				= 0.0036,
		gb_min_dist				= 3200,
		gb_use_time				= 5.3,
		gb_max_retW				= 0.4,
		gb_ret_Kp				= 1.1,
	},

	autopilot = {
		Kp					= 0.062,
		Ki					= 0.056,
		Kd					= 0.036,
		max_ctrl_angle		= 1.15,
		delay				= 0.7,
		op_time				= 18,
		fins_discreet		= 0.08,
		no_ctrl_center_ang	= 0.00002,
		fins_limit			= 1,

		self_destruct_maneuver			= 1,
		self_destruct_maneuver_cmd_y	= 0.3,
		self_destruct_maneuver_cmd_z	= 0.6,
		self_destruct_start_timer		= 18,
		self_destruct_command_timer		= 3,
		self_destruct_no_signal_lim		= 0.5,
	},

	fm = {
		mass				= 42.5,
		caliber				= 0.13,
		L					= 1.83,
		I					= 1 / 12 * 49.5 * 1.83 * 1.83,
		Ma					= 2,
		Mw					= 5,
		cx_coeff			= {1, 1.5, 1.2, 0.2, 1.3},
		Sw					= 0.12,
		dCydA				= {0.024, 0.018},
		A					= 0.6,
		maxAoa				= 0.2,
		finsTau				= 0.05,
		freq				= 4,
	},

	eng_err = {
		y_error				= 0,
		z_error				= 0.1,
		min_time_interval	= 0.1,
		max_time_interval	= 1,
	},

	fuze = {
		default_arm_delays = { 0.8 }
	},

	shape_table_data = {{
		name		= _("9M120F"),
		file		= "9M120F",
		username	= _("9M120F"),
		index		= WSTYPE_PLACEHOLDER
	}},

	warhead		= predefined_warhead("9M120F"),
}
declare_weapon(Ataka_9M120F)

Ataka_9M220 = {
	category		= CAT_MISSILES,
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Missile, wsType_AS_Missile, WSTYPE_PLACEHOLDER},
	name			= "Ataka_9M220",
	user_name		= _("9M220O Ataka (AT-9 Spiral-2)"),
	scheme			= "shturm_new",
	class_name		= "wAmmunitionVikhr",
	model			= "9M120F",
	display_name_short = _("9M220"),

	Escort			= 1,
	Head_Type		= 7,
	sigma			= {4, 4, 4},
	M				= 49.5,
	H_max			= 4000,
	H_min			= -1,
	Diam			= 130,
	Cx_pil			= 0,
	D_max			= 6000,
	D_min			= 800,
	Head_Form		= 1,
	Life_Time		= 30,
	Nr_max			= 1.2,
	v_min			= 170,
	v_mid			= 300,
	Mach_max		= 1.8,
	t_b				= 0,
	t_acc			= 5,
	t_marsh			= 0,
	Range_max		= 6000,
	H_min_t			= 0,
	Fi_start		= 0.1,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.4,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= -0.922,
	Y_back			= 0,
	Z_back			= 0,
	Reflection		= 0.03,
	KillDistance	= 4,

	booster = {
		impulse							= 220,
		fuel_mass						= 1,
		work_time						= 0.05,
		nozzle_position					= {{-1.08, 0, 0}},
		tail_width						= 0.13,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.8,
		custom_smoke_dissipation_factor	= 0.5,
	},

	march = {
		impulse							= 240,
		fuel_mass						= 5.53, -- 6500N for 2s
		work_time						= 2,
		nozzle_position					= {{-0.515, 0, 0.07},{-0.515, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0},{0, 0.2, 0}},
		tail_width						= 0.06,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	march2 = {
		impulse							= 250,
		fuel_mass						= 4.29, -- 3500N for 3s
		work_time						= 3,
		nozzle_position					= {{-0.515, 0, 0.07},{-0.515, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0},{0, 0.2, 0}},
		tail_width						= 0.06,
		smoke_color						= {0.8, 0.8, 0.8},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	march_smoke = {
		impulse							= 0.5,
		fuel_mass						= 0.6,
		work_time						= 0.5,
		nozzle_position					= {{-0.515, 0, 0.07},{-0.515, 0,-0.07}},
		nozzle_orientationXYZ			= {{0, -0.2, 0.15},{0, 0.2, 0}},
		tail_width						= 0.13,
		smoke_color						= {0.1, 0.1, 0.1},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 1,
	},

	spiral_nav = {
		t_cone_near_rad			= 1000,
		def_cone_max_dist		= 7500,
		def_cone_near_rad		= 1000,
		def_cone_near_rad_st	= 0,
		def_cone_time_stab_rad	= 0,
		gb_angle				= 0.0036,
		gb_min_dist				= 3200,
		gb_use_time				= 5.3,
		gb_max_retW				= 0.4,
		gb_ret_Kp				= 1.1,
	},

	autopilot = {
		Kp					= 0.062,
		Ki					= 0.056,
		Kd					= 0.036,
		max_ctrl_angle		= 1.15,
		delay				= 0.7,
		op_time				= 18,
		fins_discreet		= 0.08,
		no_ctrl_center_ang	= 0.00002,
		fins_limit			= 1,

		self_destruct_maneuver			= 1,
		self_destruct_maneuver_cmd_y	= 0.3,
		self_destruct_maneuver_cmd_z	= 0.6,
		self_destruct_start_timer		= 18,
		self_destruct_command_timer		= 3,
		self_destruct_no_signal_lim		= 0.5,
	},

	fm = {
		mass				= 42.5,
		caliber				= 0.13,
		L					= 1.83,
		I					= 1 / 12 * 49.5 * 1.83 * 1.83,
		Ma					= 2,
		Mw					= 5,
		cx_coeff			= {1, 1.5, 1.2, 0.2, 1.3},
		Sw					= 0.12,
		dCydA				= {0.024, 0.018},
		A					= 0.6,
		maxAoa				= 0.2,
		finsTau				= 0.05,
		freq				= 4,
	},

	eng_err = {
		y_error				= 0,
		z_error				= 0.1,
		min_time_interval	= 0.1,
		max_time_interval	= 1,
	},

	fuze = {
		default_proximity_radius	= 4,
		default_arm_delays			= { 0.8 },
		is_proxy_tdd_always_enabled	= true,
		tdd_position				= { 0.83, 0, 0 }
	},

	shape_table_data = {{
		name		= _("9M220O"),
		file		= "9M120F",
		username	= _("9M220O"),
		index		= WSTYPE_PLACEHOLDER
	}},

	warhead		= predefined_warhead("9M220"),
}
declare_weapon(Ataka_9M220)

Vikhr_9M127 = {
	category		= CAT_MISSILES,
	wsTypeOfWeapon	= { wsType_Weapon, wsType_Missile, wsType_AS_Missile, Vikhr_M },
	name			= "Vikhr_M",
	user_name		= _("9M127 Vikhr"),
	
	scheme			= "command_guided_spin_missile",
	class_name		= "wAmmunitionVikhr",
	model			= "vikhr",
	display_name_short = _("9M127"),  -- 9M127 Vikhr_M

	Escort			= 1,
	Head_Type		= 4,
	sigma			= {3, 3, 3},
	M				= 45,
	H_max			= 5000,
	H_min			= 5,
	Diam			= 130,
	Cx_pil			= 1,
	D_max			= 7000,
	D_min			= 800,
	Head_Form		= 0,
	Life_Time		= 30,
	Nr_max			= 12,
	v_min			= 170,
	v_mid			= 461,
	Mach_max		= 2.2,
	t_b				= 0,
	t_acc			= 5,
	t_marsh			= 5,
	Range_max		= 11000,
	H_min_t			= 0,
	Fi_start		= 0.0175,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.8,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= -1.2,
	Y_back			= 0,
	Z_back			= 0,
	Reflection		= 0.03,
	KillDistance	= 7,

	controller = {
		boost_start = 0,
		march_start = 0.5,
	},

	booster = {
		impulse							= 220,
		fuel_mass						= 5.1,
		work_time						= 0.5,
		nozzle_position					= {{-1.375, 0, -0.034}, {-1.375, 0, 0.034}},
		nozzle_orientationXYZ			= {{0, 0, 0}, {0, 0, 0}},
		tail_width						= 0.2,
		smoke_color						= {1, 1, 1},
		smoke_transparency				= 0.2,
		custom_smoke_dissipation_factor	= 0.8,
		max_effect_length				= 10
	},
	
	march = {
		impulse							= 240,
		fuel_mass						= 8.1,
		work_time						= 6.3,
		nozzle_position					= {{0.165, 0, -0.064}, {0.165, 0, 0.064}},
		nozzle_orientationXYZ			= {{-0.946, 0, -0.325}, {-0.946, 0, 0.325}},
		tail_width						= 0.05,
		smoke_color						= {1, 1, 1},
		smoke_transparency				= 0.01,
		custom_smoke_dissipation_factor	= 0.2,
	},

	spiral_nav = {
		def_cone_max_dist		= 8500,
		t_cone_near_rad			= 1000,
		def_cone_near_rad		= 15,
		def_cone_near_rad_st	= 50,
		def_cone_time_stab_rad	= 5,
		gb_angle				= 0,
		gb_min_dist				= 0,
		gb_use_time				= 0,
		gb_max_retW				= 0,
		gb_ret_Kp				= 0,
	},

	autopilot = {
		Kp					= 0.078,
		Ki					= 0.058,
		Kd					= 0.038,
		max_ctrl_angle		= 1.35,
		delay				= 0.2,
		op_time				= 24,
		fins_discreet		= 0.04,
		no_ctrl_center_ang	= 0.00004,
		fins_limit			= 3.0,
		
		ray_limit_data		= {	2.0,	math.rad(5),
								12.0,	math.rad(0.5) },
	},

	fm = {
		mass		= 45,
		caliber		= 0.13,
		L			= 2.75,
		I			= 1 / 12 * 45 * 2.75 ^ 2,
		Ma			= 2,
		Mw			= 5,
		cx_coeff	= {1, 0.65, 0.85, 0.85, 1.4},
		Sw			= 0.1,
		dCydA		= {0.024, 0.018},
		A			= 0.6,
		maxAoa		= 0.2,
		finsTau		= 0.1,
		freq		= 2,
	},

	eng_err = {
		y_error = 0,
		z_error = 0,
		min_time_interval = 0.1,
		max_time_interval = 1,
	},

	fuze = {
		default_arm_delays = { 0.8 },
		default_function_delays = { 0, 0.02 },
		default_proximity_radius = 7,
		tdd_position = { 1.09, 0, 0 }
	},

	warhead = predefined_warhead("Vikhr"),

	shape_table_data = {{
		name		= _("9M127"),
		file		= "vikhr",
		username	= _("9M127 Vikhr"),
		index		= Vikhr_M
	}},
}
declare_weapon(Vikhr_9M127)

declare_loadout({
	category			= CAT_MISSILES,
	CLSID				= "{9M114 Shturm-V-2 Rack}",
	Picture				= "24_ME_Empty_ATGM_Launch.png",
	Cx_pil				= 0.001,
	displayName			= _("Missile Launcher Rack (Empty)"),
	Weight				= 13,
	Count				= 0,
	attribute			= {4, 4, 32, WSTYPE_PLACEHOLDER},
	Elements			= {{ ShapeName = "9M114-PYLON_EMPTY", IsAdapter = true }}
})

declare_loadout({
	category			= CAT_MISSILES,
	CLSID				= "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
	Picture				= "24_ME_ATGM_Launch+2_Miss.png",
	Cx_pil				= 0.001,
	displayName			= "2 x " .. AT_6.user_name .. " - " .. _("ATGM, SACLOS, HEAT"),
	NatoName			= "AT-6",
	Weight				= 19 + 2 * (7 + AT_6.fm.mass),
	Weight_Empty		= 19 + 2 * 7,
	Count				= 2,
	kind_of_shipping	= 0,
	attribute			= {4, 4, 32, 60},
	wsTypeOfWeapon		= AT_6.wsTypeOfWeapon,
	Elements			= {{ ShapeName = "9M114-PILON", IsAdapter = true }}
})

declare_loadout({
	category			= CAT_MISSILES,
	CLSID				= "{2x9M114_with_adapter}",
	Picture				= "24_ME_ATGM_Launch+2_Miss.png",
	Cx_pil				= 0.001,
	displayName			= "2 x " .. AT_6.user_name .. " - " .. _("ATGM, SACLOS, HEAT"),
	NatoName			= "AT-6",
	Weight				= 24 + 2 * (7 + AT_6.fm.mass),
	Weight_Empty		= 24 + 2 * 7,
	Count				= 2,
	kind_of_shipping	= 0,
	attribute			= {4, 4, 32, 60},
	wsTypeOfWeapon		= AT_6.wsTypeOfWeapon,
	Elements			= {{ ShapeName = "9m114_pylon2", IsAdapter = true }}
})

declare_loadout({
	category			= CAT_MISSILES,
	CLSID				= "{57232979-8B0F-4db7-8D9A-55197E06B0F5}",
	Picture				= "apu8.png",
	Cx_pil				= 0.002,
	displayName			= "8 x " .. AT_6.user_name .. " - " .. _("ATGM, SACLOS, HEAT"),
	NatoName			= "AT-6",
	Weight				= 50 + 8 * (15.5 + AT_6.fm.mass),
	Weight_Empty		= 50 + 8 * 15.5,
	Count				= 8,
	kind_of_shipping	= 0,
	attribute			= {4, 4, 32, 113},
	wsTypeOfWeapon		= AT_6.wsTypeOfWeapon,
	Elements			= {{ ShapeName = "9K114_Shturm", IsAdapter = true }}
})

declare_loadout({
	category			= CAT_MISSILES,
	CLSID				= "{2x9M120_Ataka_V}",
	Picture				= "24_ME_ATGM_Launch+2_Miss.png",
	Cx_pil				= 0.001,
	displayName			= "2 x " .. Ataka_9M120.user_name .. " - " .. _("ATGM, SACLOS, Tandem HEAT"),
	NatoName			= "AT-9",
	Weight				= 19 + 2 * (7 + Ataka_9M120.fm.mass),
	Weight_Empty		= 19 + 2 * 7,
	Count				= 2,
	kind_of_shipping	= 0,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon		= Ataka_9M120.wsTypeOfWeapon,
	Elements			= {{ ShapeName = "9M120_pylon", IsAdapter = true }}
})

declare_loadout({
	category			= CAT_MISSILES,
	CLSID				= "{2x9M120_Ataka_V_with_adapter}",
	Picture				= "24_ME_ATGM_Launch+2_Miss.png",
	Cx_pil				= 0.001,
	displayName			= "2 x " .. Ataka_9M120.user_name .. " - " .. _("ATGM, SACLOS, Tandem HEAT"),
	NatoName			= "AT-9",
	Weight				= 24 + 2 * (7 + Ataka_9M120.fm.mass),
	Weight_Empty		= 24 + 2 * 7,
	Count				= 2,
	kind_of_shipping	= 0,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon		= Ataka_9M120.wsTypeOfWeapon,
	Elements			= {{ ShapeName = "9M120_pylon2", IsAdapter = true }}
})

declare_loadout({
	category			= CAT_MISSILES,
	CLSID				= "{2x9M120F_Ataka_V}",
	Picture				= "24_ME_ATGM_Launch+2_Miss.png",
	Cx_pil				= 0.001,
	displayName			= "2 x " .. Ataka_9M120F.user_name .. " - " .. _("AGM, SACLOS, HE"),
	NatoName			= "AT-9",
	Weight				= 19 + 2 * (7 + Ataka_9M120F.fm.mass),
	Weight_Empty		= 19 + 2 * 7,
	Count				= 2,
	kind_of_shipping	= 0,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon		= Ataka_9M120F.wsTypeOfWeapon,
	Elements			= {{ ShapeName = "9M120_pylon", IsAdapter = true }}
})

declare_loadout({
	category			= CAT_MISSILES,
	CLSID				= "{2x9M120F_Ataka_V_with_adapter}",
	Picture				= "24_ME_ATGM_Launch+2_Miss.png",
	Cx_pil				= 0.001,
	displayName			= "2 x " .. Ataka_9M120F.user_name .. " - " .. _("AGM, SACLOS, HE"),
	NatoName			= "AT-9",
	Weight				= 24 + 2 * (7 + Ataka_9M120F.fm.mass),
	Weight_Empty		= 24 + 2 * 7,
	Count				= 2,
	kind_of_shipping	= 0,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon		= Ataka_9M120F.wsTypeOfWeapon,
	Elements			= {{ ShapeName = "9M120_pylon2", IsAdapter = true }}
})

declare_loadout({
	category			= CAT_AIR_TO_AIR,
	CLSID				= "{2x9M220_Ataka_V}",
	Picture				= "24_ME_ATGM_Launch+2_Miss.png",
	Cx_pil				= 0.001,
	displayName			= "2 x " .. Ataka_9M220.user_name .. " - " .. _("AAM, SACLOS, Frag"),
	NatoName			= "AT-9",
	Weight				= 13 + 2 * (7 + Ataka_9M220.fm.mass),
	Weight_Empty		= 13 + 2 * 7,
	Count				= 2,
	kind_of_shipping	= 0,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon		= Ataka_9M220.wsTypeOfWeapon,
	Elements			= {{ ShapeName = "9M120_pylon", IsAdapter = true }}
})

declare_loadout({
	category			= CAT_AIR_TO_AIR,
	CLSID				= "{2x9M220_Ataka_V_with_adapter}",
	Picture				= "24_ME_ATGM_Launch+2_Miss.png",
	Cx_pil				= 0.001,
	displayName			= "2 x " .. Ataka_9M220.user_name .. " - " .. _("AAM, SACLOS, Frag"),
	NatoName			= "AT-9",
	Weight				= 24 + 2 * (7 + Ataka_9M220.fm.mass),
	Weight_Empty		= 24 + 2 * 7,
	Count				= 2,
	kind_of_shipping	= 0,
	attribute			= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon		= Ataka_9M220.wsTypeOfWeapon,
	Elements			= {{ ShapeName = "9M120_pylon2", IsAdapter = true }}
})

declare_loadout({
	category			= CAT_MISSILES,
	CLSID				= "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
	Picture				= "APU8.png",
	Cx_pil				= 0.001,
	Cx_item				= 0,
	displayName			= ("%s - 8 x %s - %s"):format(_("APU-8"), Vikhr_9M127.user_name, _("ATGM, LOSBR, Tandem HEAT/Frag")),
	NatoName			= "(AT-16)",
	Weight				= 60 + 8 * (14.375 + Vikhr_9M127.fm.mass),
	Weight_Empty		= 60 + 8 * 14.375,
	Count				= 8,
	kind_of_shipping	= 0,
	attribute			= {4, 4, 32, 47},
	wsTypeOfWeapon		= Vikhr_9M127.wsTypeOfWeapon,
	Elements			= {
		{ ShapeName	=	"9M120" },
		{ Position	=	{0,	-0.235,	-0.263} },
		{ Position	=	{0,	-0.235,	-0.116} },
		{ Position	=	{0,	-0.235,	 0.116} },
		{ Position	=	{0,	-0.235,	 0.263} },
		{ Position	=	{0,	-0.474,	-0.263} },
		{ Position	=	{0,	-0.474,	-0.116} },
		{ Position	=	{0,	-0.474,	 0.116} },
		{ Position	=	{0,	-0.474,	 0.263} },
	}
})

declare_loadout({
	category			= CAT_MISSILES,
	CLSID				= "{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}",
	Picture				= "APU6.png",
	Cx_pil				= 0.001,
	Cx_item				= 0,
	displayName			= ("%s - 6 x %s - %s"):format(_("APU-6"), Vikhr_9M127.user_name, _("ATGM, LOSBR, Tandem HEAT/Frag")),
	NatoName			= "(AT-16)",
	Weight				= 60 + 6 * (14.375 + Vikhr_9M127.fm.mass),
	Weight_Empty		= 60 + 6 * 14.375,
	Count				= 6,
	kind_of_shipping	= 0,
	attribute			= {4, 4, 32, 86},
	wsTypeOfWeapon		= Vikhr_9M127.wsTypeOfWeapon,
	Elements			= {{ ShapeName = "9k121", IsAdapter = true }},
})


local C701T =
{
	category		= CAT_MISSILES,
	name			= "C_701T",
	user_name		= _("C-701T"),
	display_name_short = "C-701",
	model			= "c701t",
	class_name		= "wAmmunitionSelfHoming",
	scheme			= "AGM-65ext",
	
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	mass = 100,
	Escort = 0,
    Head_Type = 5,
	sigma = {5, 5, 5},
	M = 100.0,
	H_max = 10000.0,
	H_min = -1,
	Diam = 305.0,
	Cx_pil = 4,
    D_max = 40000.0,
    D_min = 500.0,
	Head_Form = 0,
	Head_Form = 0,
	Life_Time = 180,
	Nr_max = 30,
	v_min = 50.0,
	v_mid = 600.0,
	Mach_max = 1.5,
	t_b = 0.0,
	t_acc = 4.0,
	t_marsh = 0.0,
	Range_max = 30000.0,
	H_min_t = 0.0,
	Fi_start = 0.5,
	Fi_rak = 3.14152,
	Fi_excort = 1.05,
	Fi_search = 99.9,
	OmViz_max = 99.9,
	exhaust = {0.75, 0.75, 0.75, 0.1},
	X_back = -0.9,
	Y_back = -0.15,
	Z_back = 0.0,
	Reflection = 0.08,
	KillDistance = 0.0,

    LaunchDistData =
	{
		4,		5,

				100,	165,	230,	300,	400,		
		50,		13000,	14250,	15000,	16500,	19000,	
		2000,	14500,	16000,	17000,	18000,	21000,	
		5000,	16500,	17500,	19000,	21000,	24000,	
		10000,	17000,	19000,	22000,	25000,	29000,	
	},

	MinLaunchDistData =
	{
		4,		5,

				100,	165,	230,	300,	400,		
		50,		1500,	1500,	1500,	1750,	1750,	
		2000,	3500,	3500,	4000,	4500,	5500,	
		5000,	7000,	8000,	8500,	9000,	9500,	
		10000,	11000,	13000,	15000,	16000,	17000,	
	},	

	shape_table_data =
	{
		{
			name		= "C_701T",
			file		= "c701t",
			life		= 1,
			fire		= { 0, 1},
			username	= _("C-701T"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	fm = {
		mass        = 100,  
		caliber     = 0.18,  
		cx_coeff    = {1,0.39,0.38,0.236,1.31},
		L           = 2.507,
		I           = 1 / 12 * 100 * 2.507 * 2.507,
		Ma          = 0.68,
		Mw          = 1.116,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 0.4,
		dCydA		= {0.07, 0.036},
		A			= 0.36,
		maxAoa		= 0.23,
		finsTau		= 0.1,
		Ma_x		= 3,
		Kw_x		= 0.03,
		I_x			= 40,
	},
	
	seeker = {
		delay			= 0.0,
		op_time			= 120,
		FOV				= math.rad(90),
		max_w_LOS		= 0.06,
		max_w_LOS_surf	= 0.03,
	
		max_target_speed			= 33,
		max_target_speed_rnd_coeff	= 10,
		
		ship_track_by_default		= 1,
		ship_track_board_vis_angle	= math.rad(60),
	},
	
	PN_autopilot = {
		K			= 0.015,
		Ki			= 0,
		Kg			= 2.0,
		Kx			= 0.02,
		fins_limit	= 0.3,
		K_GBias		= 0.15,
	},
	
	boost = {
        impulse								= 125,
        fuel_mass							= 12,
        work_time							= 3,
        nozzle_position						= {{-1.13, 0, 0}},
        nozzle_orientationXYZ				= {{0, 0, 0}},
        tail_width							= 0.2,
        smoke_color							= {0.6, 0.6, 0.6},
        smoke_transparency					= 0.8,
        custom_smoke_dissipation_factor		= 0.2,       
    },
	
    march = {
        impulse								= 150,
        fuel_mass							= 12,
        work_time							= 12,
        nozzle_position						= {{-1.13, 0, 0}},
        nozzle_orientationXYZ				= {{0, 0, 0}},
        tail_width							= 0.2,
        smoke_color							= {0.9, 0.9, 0.9},
        smoke_transparency					= 0.9,
        custom_smoke_dissipation_factor		= 0.2,                
    },
	
	warhead = predefined_warhead("C701"),
	warhead_air = predefined_warhead("C701"),
}

declare_weapon(C701T)

declare_loadout({
    category         = CAT_MISSILES,
    CLSID            = "{DIS_C-701T}",
    attribute        = C701T.wsTypeOfWeapon,
    Count            = 1,
    Cx_pil           = 0.0006265625,
    Picture          = "c701t.png",
    displayName      = _("C-701T"),
    Weight           = 100 + 70,
    Elements         = {{ShapeName = "c701t"}},
    ejectVelocity    = 1.5,
})

local C701IR =
{
	category		= CAT_MISSILES,
	name			= "C_701IR",
	user_name		= _("C-701IR"),
	display_name_short = "C-701",
	model			= "c701t",
	class_name		= "wAmmunitionSelfHoming",
	scheme			= "AGM-65ext",
	
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	mass = 100,
	Escort = 0,
    Head_Type = 5,
	sigma = {5, 5, 5},
	M = 100.0,
	H_max = 10000.0,
	H_min = -1,
	Diam = 305.0,
	Cx_pil = 4,
    D_max = 40000.0,
    D_min = 500.0,
	Head_Form = 0,
	Head_Form = 0,
	Life_Time = 180,
	Nr_max = 30,
	v_min = 50.0,
	v_mid = 600.0,
	Mach_max = 1.5,
	t_b = 0.0,
	t_acc = 4.0,
	t_marsh = 0.0,
	Range_max = 30000.0,
	H_min_t = 0.0,
	Fi_start = 0.5,
	Fi_rak = 3.14152,
	Fi_excort = 1.05,
	Fi_search = 99.9,
	OmViz_max = 99.9,
	exhaust = {0.75, 0.75, 0.75, 0.1},
	X_back = -0.9,
	Y_back = -0.15,
	Z_back = 0.0,
	Reflection = 0.08,
	KillDistance = 0.0,

    LaunchDistData =
	{
		4,		5,

				100,	165,	230,	300,	400,		
		50,		13000,	14250,	15000,	16500,	19000,	
		2000,	14500,	16000,	17000,	18000,	21000,	
		5000,	16500,	17500,	19000,	21000,	24000,	
		10000,	17000,	19000,	22000,	25000,	29000,	
	},

	MinLaunchDistData =
	{
		4,		5,

				100,	165,	230,	300,	400,		
		50,		1500,	1500,	1500,	1750,	1750,	
		2000,	3500,	3500,	4000,	4500,	5500,	
		5000,	7000,	8000,	8500,	9000,	9500,	
		10000,	11000,	13000,	15000,	16000,	17000,	
	},	

	shape_table_data =
	{
		{
			name		= "C_701IR",
			file		= "c701t",
			life		= 1,
			fire		= { 0, 1},
			username	= _("C-701IR"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	fm = {
		mass        = 100,  
		caliber     = 0.18,  
		cx_coeff    = {1,0.39,0.38,0.236,1.31},
		L           = 2.507,
		I           = 1 / 12 * 100 * 2.507 * 2.507,
		Ma          = 0.68,
		Mw          = 1.116,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 0.4,
		dCydA		= {0.07, 0.036},
		A			= 0.36,
		maxAoa		= 0.23,
		finsTau		= 0.1,
		Ma_x		= 3,
		Kw_x		= 0.03,
		I_x			= 40,
	},
	
	seeker = {
		delay			= 0.0,
		op_time			= 120,
		FOV				= math.rad(90),
		max_w_LOS		= 0.06,
		max_w_LOS_surf	= 0.03,
	
		max_target_speed			= 33,
		max_target_speed_rnd_coeff	= 10,
		
		ship_track_by_default		= 1,
		ship_track_board_vis_angle	= math.rad(60),
	},
	
	PN_autopilot = {
		K			= 0.015,
		Ki			= 0,
		Kg			= 2.0,
		Kx			= 0.02,
		fins_limit	= 0.3,
		K_GBias		= 0.15,
	},
	
	boost = {
        impulse								= 125,
        fuel_mass							= 12,
        work_time							= 3,
        nozzle_position						= {{-1.13, 0, 0}},
        nozzle_orientationXYZ				= {{0, 0, 0}},
        tail_width							= 0.2,
        smoke_color							= {0.6, 0.6, 0.6},
        smoke_transparency					= 0.8,
        custom_smoke_dissipation_factor		= 0.2,       
    },
	
    march = {
        impulse								= 150,
        fuel_mass							= 12,
        work_time							= 12,
        nozzle_position						= {{-1.13, 0, 0}},
        nozzle_orientationXYZ				= {{0, 0, 0}},
        tail_width							= 0.2,
        smoke_color							= {0.6, 0.6, 0.6},
        smoke_transparency					= 0.8,
        custom_smoke_dissipation_factor		= 0.2,                
    },
	
	warhead = predefined_warhead("C701"),
	warhead_air = predefined_warhead("C701"),
}

declare_weapon(C701IR)

declare_loadout({
    category         = CAT_MISSILES,
    CLSID            = "{DIS_C-701IR}",
    attribute        = C701IR.wsTypeOfWeapon,
    Count            = 1,
    Cx_pil           = 0.0006265625,
    Picture          = "c701t.png",
    displayName      = _("C-701IR"),
    Weight           = 100 + 70,
    Elements         = {{ShapeName = "c701t"}},
    ejectVelocity    = 1.5,
})

local SPIKE_ER =
{
	category		= CAT_MISSILES,
	name			= "SPIKE_ER",
	display_name 	= _('SPIKE-ER'),
	user_name		= _("SPIKE-ER"),
	display_name_short = "Spike",
	scheme			= "spike",
	class_name		= "wAmmunitionSelfHoming",
	model			= "SPIKE_ER",
		
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	
	shape_table_data =
	{
		{
			file  = "SPIKE_ER";
			life  = 1;
			fire  = {0, 1};
			name  	 = "SPIKE_ER";
			username = "SPIKE-ER";
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	Escort = 0,
	Head_Type = 5,
	sigma = {4, 4, 4},
	mass = 26,
	M = 26,
	H_max = 3800.0,
	H_min = -1,
	Diam = 170.0,
	Cx_pil = 2,
	D_max = 16000.0,
	D_min = 400.0,
	Head_Form = 1,
	Life_Time = 150.0,
	Nr_max = 16,
	v_min = 0,
	v_mid = 250.0,
	Mach_max = 0.7,
	t_b = 0.0,
	t_acc = 0.08,
	t_marsh = 32.0,
	Range_max = 8000.0,
	H_min_t = 0.0,
	Fi_start = 0.44,
	Fi_rak = 3.14152,
	Fi_excort = 0.44,
	Fi_search = 99.9,
	OmViz_max = 99.9,
	exhaust = {0.9, 0.9, 0.85, 0.1};
	X_back = -0.95,
	Y_back = 0.0,
	Z_back = 0.0,
	Reflection = 0.03,
	KillDistance = 0.0,
	
	add_attributes = {"encyclopedia_hidden"},

	precursor = predefined_warhead("SPIKE_ER_precursor"),
	warhead = predefined_warhead("SPIKE_ER_main"),
		
	engine_controller = {
		boost_start = 0,
		march_start = 0.3,
	},

	seeker = {
		delay				= 0.0,
		op_time				= 150,
		activate_on_update	= 0,

		FOV					= math.rad(100),
		max_w_LOS			= 0.06,
		max_w_LOS_surf		= 0.017,

		max_target_speed			= 40,
		max_target_speed_rnd_coeff	= 10,

		max_lock_dist		= 12500,
		target_mem_time 	= 0,
	},
	
	booster = {
		impulse								= 180,
		fuel_mass							= 0.4,
		work_time							= 0.08,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{-0.8, 0.0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.045,
		smoke_color							= {0.8, 0.8, 0.8},
		smoke_transparency					= 0.2,
		custom_smoke_dissipation_factor		= 0.0,
	},

	march = {
		impulse								= 240,
		fuel_mass							= 5.0,
		work_time							= 40,
		boost_time							= 2,
		boost_factor						= 12,
		nozzle_position						= {{0.023, 0.0, 0.062},{0.023, 0.0, -0.062}},
		nozzle_orientationXYZ				= {{0.0, -0.9, 0.0},{0.0, 0.9, 0.0}},
		tail_width							= 0.045,
		smoke_color							= {0.7, 0.7, 0.7},
		smoke_transparency					= 0.013,
		custom_smoke_dissipation_factor		= 0.013,
	},	
	
	fm = {
		mass        = 26.2,
		caliber     = 0.150,
		cx_coeff    = {1,0.28,0.43,0.18,1.12},
		L           = 1.62,
		I           = 4.9, --1 / 12 * 26 * 1.62 * 1.62,
		Ma          = 4.0,
		Mw          = 5.0,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 0.078,
		dCydA		= {0.044, 0.028},
		A			= 0.4,
		maxAoa		= 0.28,
		finsTau		= 0.1,
		Ma_x		= 0.3,
		Mw_x		= 15,
		I_x			= 2,
		ideal_fins	= true,
		model_roll 	= 0,
		wingsDeplDelay = 0.1,
		draw_fins_conv = {0.1745, 0.1745, 0.1745}
	},

	--wcs ports
	--manual_angles - vec3d - angles (in missile body axes) representing desired LOS for manual mode
	--traj_mode - integer - trajectory: 0 - low, 1 - medium, 2 - high

	wcs = {
		KPN = 4,
		Kman = 0.3,
		Kloft = 1,
		Kroll = 1,
		pitch_bias = math.rad(1.),
		rate_bias = math.rad(0.),
		loft_pitch = 0.5,
		loft_ang_hi = math.rad(12),
		loft_ang_lo = math.rad(5),
		LPF_tau = 0.9,
		cruise_alpha = math.rad(1.86),
		tign = 0.3,
	},

	ap = {
		omega_lim			= math.rad(200),
		llf_tau				= 0.01, --0.01,
		llf_tau2			= 0.01428,-- 0.0258186, --0.014184,--0.0252525,
		llf2_tau			= 1,
		llf2_tau2			= 0.111111,
		Kll					= 135,
		Kd					= 0.5,
		Kdr					= 0.1,
		fin_roll_limit		= math.rad(10),
		fin_limit			= 1.5,
	},

	LaunchDistData =
	{
		11,		5,
	
				0,	50,	100,	150,	200,		
		100,	12000,	12000,	12000,	12000,	12000,	
		200,	12000,	12000,	12000,	12000,	12000,	
		300,	12000,	12000,	12000,	12000,	12000,	
		400,	12000,	12000,	12000,	12000,	12000,	
		500,	12000,	12000,	12000,	12000,	12000,	
		600,	12000,	12000,	12000,	12000,	12000,	
		700,	12000,	12000,	12000,	12000,	12000,	
		800,	12000,	12000,	12000,	12000,	12000,	
		900,	12000,	12000,	12000,	12000,	12000,	
		1000,	12000,	12000,	12000,	12000,	12000,	
		2000,	12000,	12000,	12000,	12000,	12000,	
	},

	MinLaunchDistData =
	{
		11,		5,
	
				0,	50,	100,	150,	200,		
		100,	150,	200,	300,	350,	450,	
		200,	200,	300,	400,	500,	550,	
		300,	300,	400,	450,	550,	650,	
		400,	350,	450,	550,	650,	700,	
		500,	450,	450,	550,	650,	750,	
		600,	550,	500,	700,	800,	900,	
		700,	600,	550,	750,	850,	950,	
		800,	700,	600,	800,	900,	950,	
		900,	800,	650,	850,	950,	1000,	
		1000,	850,	750,	900,	1000,	1050,	
		2000,	1700,	1350,	1700,	1700,	1700,	
	}

}
declare_weapon(SPIKE_ER)


declare_loadout({
	category			= CAT_MISSILES,
	CLSID				= "4xSPIKE_ER",
	Picture				= "agm114.png",
	Cx_pil				= 0.00208,
	displayName			= "4 x " .. SPIKE_ER.user_name,
	NatoName			= "SPIKE",
	Weight				= 64.9 + 4 * SPIKE_ER.fm.mass,
	Weight_Empty		= 64.9,
	Count				= 4,
	kind_of_shipping	= 0,
	attribute			= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon		= SPIKE_ER.wsTypeOfWeapon,
	Elements			= ContainerWithSubshapes(MLData.M299.modelFileName, "SPIKE-ER", 4, MLData.M299.connNamePattern)
})

local SPIKE_ERA =
{
	category		= CAT_MISSILES,
	name			= "SPIKE_ERA",
	display_name 	= _('SPIKE-ER/A'),
	user_name		= _("SPIKE-ER/A"),
	display_name_short = "Spike",
	scheme			= "spike",
	class_name		= "wAmmunitionSelfHoming",
	model			= "SPIKE_ER",
		
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	
	shape_table_data =
	{
		{
			file  = "SPIKE_ER";
			life  = 1;
			fire  = {0, 1};
			name  	 = "SPIKE_ER";
			username = "SPIKE-ER";
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	Escort = 0,
	Head_Type = 5,
	sigma = {4, 4, 4},
	mass = 26.2,
	M = 26.2,
	H_max = 3800.0,
	H_min = -1,
	Diam = 170.0,
	Cx_pil = 2,
	D_max = 12000.0,
	D_min = 400.0,
	Head_Form = 1,
	Life_Time = 150.0,
	Nr_max = 16,
	v_min = 0,
	v_mid = 250.0,
	Mach_max = 0.7,
	t_b = 0.0,
	t_acc = 0.08,
	t_marsh = 32.0,
	Range_max = 8000.0,
	H_min_t = 0.0,
	Fi_start = 0.44,
	Fi_rak = 3.14152,
	Fi_excort = 0.44,
	Fi_search = 99.9,
	OmViz_max = 99.9,
	exhaust = {0.9, 0.9, 0.85, 0.1};
	X_back = -0.95,
	Y_back = 0.0,
	Z_back = 0.0,
	Reflection = 0.03,
	KillDistance = 0.0,
	
	add_attributes = {"encyclopedia_hidden"},

	precursor = predefined_warhead("SPIKE_ERA"),
	warhead = simple_warhead(0.0001,0.14), --nothing
		
	engine_controller = {
		boost_start = 0,
		march_start = 0.3,
	},

	seeker = {
		delay				= 0.0,
		op_time				= 150,
		activate_on_update	= 0,

		FOV					= math.rad(100),
		max_w_LOS			= 0.06,
		max_w_LOS_surf		= 0.017,

		max_target_speed			= 40,
		max_target_speed_rnd_coeff	= 10,

		max_lock_dist		= 12500,
		target_mem_time 	= 0,
	},
	
	booster = {
		impulse								= 180,
		fuel_mass							= 0.4,
		work_time							= 0.08,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{-0.8, 0.0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.045,
		smoke_color							= {0.8, 0.8, 0.8},
		smoke_transparency					= 0.2,
		custom_smoke_dissipation_factor		= 0.0,
	},

	march = {
		impulse								= 240,
		fuel_mass							= 5.0,
		work_time							= 40,
		boost_time							= 2,
		boost_factor						= 12,
		nozzle_position						= {{0.023, 0.0, 0.062},{0.023, 0.0, -0.062}},
		nozzle_orientationXYZ				= {{0.0, -0.9, 0.0},{0.0, 0.9, 0.0}},
		tail_width							= 0.045,
		smoke_color							= {0.7, 0.7, 0.7},
		smoke_transparency					= 0.013,
		custom_smoke_dissipation_factor		= 0.013,
	},	
	
	fm = {
		mass        = 26.2,
		caliber     = 0.150,
		cx_coeff    = {1,0.28,0.43,0.18,1.12},
		L           = 1.62,
		I           = 4.9, --1 / 12 * 26 * 1.62 * 1.62,
		Ma          = 4.0,
		Mw          = 5.0,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 0.078,
		dCydA		= {0.044, 0.028},
		A			= 0.4,
		maxAoa		= 0.28,
		finsTau		= 0.1,
		Ma_x		= 0.3,
		Mw_x		= 15,
		I_x			= 2,
		ideal_fins	= true,
		model_roll 	= 0,
		wingsDeplDelay = 0.1,
		draw_fins_conv = {0.1745, 0.1745, 0.1745}
	},

	--wcs ports
	--manual_angles - vec3d - angles (in missile body axes) representing desired LOS for manual mode
	--traj_mode - integer - trajectory: 0 - low, 1 - medium, 2 - high

	wcs = {
		KPN = 4,
		Kman = 0.3,
		Kloft = 1,
		Kroll = 1,
		pitch_bias = math.rad(1.),
		rate_bias = math.rad(0.),
		loft_pitch = 0.5,
		loft_ang_hi = math.rad(12),
		loft_ang_lo = math.rad(5),
		LPF_tau = 0.9,
		cruise_alpha = math.rad(1.86),
		tign = 0.3,
	},

	ap = {
		omega_lim			= math.rad(200),
		llf_tau				= 0.01, --0.01,
		llf_tau2			= 0.01428,-- 0.0258186, --0.014184,--0.0252525,
		llf2_tau			= 1,
		llf2_tau2			= 0.111111,
		Kll					= 135,
		Kd					= 0.5,
		Kdr					= 0.1,
		fin_roll_limit		= math.rad(10),
		fin_limit			= 1.5,
	},

	LaunchDistData =
	{
		11,		5,
	
				0,	50,	100,	150,	200,		
		100,	12000,	12000,	12000,	12000,	12000,	
		200,	12000,	12000,	12000,	12000,	12000,	
		300,	12000,	12000,	12000,	12000,	12000,	
		400,	12000,	12000,	12000,	12000,	12000,	
		500,	12000,	12000,	12000,	12000,	12000,	
		600,	12000,	12000,	12000,	12000,	12000,	
		700,	12000,	12000,	12000,	12000,	12000,	
		800,	12000,	12000,	12000,	12000,	12000,	
		900,	12000,	12000,	12000,	12000,	12000,	
		1000,	12000,	12000,	12000,	12000,	12000,	
		2000,	12000,	12000,	12000,	12000,	12000,	
	},

	MinLaunchDistData =
	{
		11,		5,
	
				0,	50,	100,	150,	200,		
		100,	150,	200,	300,	350,	450,	
		200,	200,	300,	400,	500,	550,	
		300,	300,	400,	450,	550,	650,	
		400,	350,	450,	550,	650,	700,	
		500,	450,	450,	550,	650,	750,	
		600,	550,	500,	700,	800,	900,	
		700,	600,	550,	750,	850,	950,	
		800,	700,	600,	800,	900,	950,	
		900,	800,	650,	850,	950,	1000,	
		1000,	850,	750,	900,	1000,	1050,	
		2000,	1700,	1350,	1700,	1700,	1700,	
	}

}
declare_weapon(SPIKE_ERA)

local SPIKE_ER2 =
{
	category		= CAT_MISSILES,
	name			= "SPIKE_ER2",
	display_name 	= _('SPIKE-ER2'),
	user_name		= _("SPIKE-ER2"),
	display_name_short = "Spike",
	scheme			= "spike_nlos",
	class_name		= "wAmmunitionSelfHoming",
	model			= "SPIKE_ER2",
		
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	
	shape_table_data =
	{
		{
			file  = "SPIKE_ER2";
			life  = 1;
			fire  = {0, 1};
			name  	 = "SPIKE_ER2";
			username = "SPIKE-ER2";
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	Escort = 0,
	Head_Type = 5,
	sigma = {4, 4, 4},
	mass = 26.2,
	M = 26.2,
	H_max = 3800.0,
	H_min = -1,
	Diam = 170.0,
	Cx_pil = 2,
	D_max = 16000.0,
	D_min = 400.0,
	Head_Form = 1,
	Life_Time = 150.0,
	Nr_max = 16,
	v_min = 0,
	v_mid = 250.0,
	Mach_max = 0.7,
	t_b = 0.0,
	t_acc = 0.08,
	t_marsh = 32.0,
	Range_max = 8000.0,
	H_min_t = 0.0,
	Fi_start = 0.44,
	Fi_rak = 3.14152,
	Fi_excort = 0.44,
	Fi_search = 99.9,
	OmViz_max = 99.9,
	exhaust = {0.9, 0.9, 0.85, 0.1};
	X_back = -0.95,
	Y_back = 0.0,
	Z_back = 0.0,
	Reflection = 0.03,
	KillDistance = 0.0,
	
	add_attributes = {"encyclopedia_hidden"},

	precursor = predefined_warhead("SPIKE_ER_precursor"),
	warhead = predefined_warhead("SPIKE_ER_main"),

	engine_controller = {
		boost_start = 0,
		march_start = 0.3,
	},

	seeker = {
		delay				= 0.0,
		op_time				= 150,
		activate_on_update	= 0,

		FOV					= math.rad(100),
		max_w_LOS			= 0.06,
		max_w_LOS_surf		= 0.017,

		max_target_speed			= 40,
		max_target_speed_rnd_coeff	= 10,

		max_lock_dist		= 16500,
		target_mem_time 	= 0,
	},
	
	booster = {
		impulse								= 180,
		fuel_mass							= 0.4,
		work_time							= 0.08,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{-0.8, 0.0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.045,
		smoke_color							= {0.8, 0.8, 0.8},
		smoke_transparency					= 0.2,
		custom_smoke_dissipation_factor		= 0.0,
	},

	march = {
		impulse								= 240,
		fuel_mass							= 5.0,
		work_time							= 40,
		boost_time							= 2,
		boost_factor						= 12,
		nozzle_position						= {{0.023, 0.0, 0.062},{0.023, 0.0, -0.062}},
		nozzle_orientationXYZ				= {{0.0, -0.9, 0.0},{0.0, 0.9, 0.0}},
		tail_width							= 0.045,
		smoke_color							= {0.7, 0.7, 0.7},
		smoke_transparency					= 0.013,
		custom_smoke_dissipation_factor		= 0.013,
	},	
	
	fm = {
		mass        = 26.2,
		caliber     = 0.150,
		cx_coeff    = {1,0.28,0.43,0.18,1.12},
		L           = 1.62,
		I           = 4.9, --1 / 12 * 26 * 1.62 * 1.62,
		Ma          = 4.0,
		Mw          = 5.0,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 0.078,
		dCydA		= {0.044, 0.028},
		A			= 0.4,
		maxAoa		= 0.28,
		finsTau		= 0.1,
		Ma_x		= 0.3,
		Mw_x		= 15,
		I_x			= 2,
		ideal_fins	= true,
		model_roll 	= 0,
		wingsDeplDelay = 0.1,
		draw_fins_conv = {0.1745, 0.1745, 0.1745}
	},
	
	--wcs ports
	--backup - boolean - fallback to SPIKE-ER guidance (INS failure)
	--manual_angles - vec3d - angles (in missile body axes) representing desired LOS for manual mode (backup only)
	--traj_mode - integer - trajectory: 0 - low, 1 - medium, 2 - high

	wcs = {
		KPN = 4,
		Kman = 0.3,
		Kloft = 1,
		Kroll = 1,
		pitch_bias = math.rad(1.),
		rate_bias = math.rad(0.),
		loft_pitch = 0.5,
		loft_ang_hi = math.rad(12),
		loft_ang_lo = math.rad(5),
		LPF_tau = 0.85,
		cruise_alpha = math.rad(1.86),
		T = 189.87,
		T_boost = 2278.45,
		tign = 0.3,
		tboost = 2.3,
		tbo = 40.3,
		S = 0.078,
		Cx0 = 0.18,
		K = 0.4,
		m = 26.2,
		mdot = 0.96774,--0.1996,
		mdot2 = 0.08064,
		med_loft_end_gamma = -0.2,
		loft_slope = 0.3,
		seeker_lim = 0.3,
		phase_1_gain = 1
	},

	ap = {
		omega_lim			= math.rad(200),
		llf_tau				= 0.01,
		llf_tau2			= 0.01428,
		llf2_tau			= 1,
		llf2_tau2			= 0.111111,
		Kll					= 135,
		Kd					= 0.5,
		Kdr					= 0.1,
		fin_roll_limit		= math.rad(10),
		fin_limit			= 1.5,

	},


	LaunchDistData =
	{
		11,		5,
	
				0,	50,	100,	150,	200,		
		100,	16000,	16000,	16000,	15500,	16000,	
		200,	16000,	16000,	15500,	15500,	16000,	
		300,	16000,	15000,	15500,	15500,	16000,	
		400,	16000,	15000,	15500,	15500,	16000,	
		500,	14500,	15000,	15500,	16000,	16000,	
		600,	14500,	15000,	15500,	16000,	16000,	
		700,	14500,	15000,	15500,	15500,	16000,	
		800,	14500,	15000,	15500,	16000,	16000,	
		900,	14500,	15000,	16000,	16000,	16000,	
		1000,	16000,	16000,	16000,	16000,	16000,	
		2000,	16000,	16000,	16000,	16000,	16000,	
	},

	MinLaunchDistData =
	{
		11,		5,
	
				0,	50,	100,	150,	200,		
		100,	150,	250,	300,	400,	450,	
		200,	300,	350,	450,	500,	550,	
		300,	400,	450,	500,	600,	650,	
		400,	500,	550,	600,	650,	700,	
		500,	550,	600,	650,	700,	750,	
		600,	650,	700,	700,	750,	800,	
		700,	700,	750,	750,	800,	800,	
		800,	750,	800,	800,	850,	850,	
		900,	800,	850,	850,	900,	900,	
		1000,	800,	950,	950,	950,	1000,	
		2000,	1400,	1450,	1500,	1500,	1500,	
	}
}
declare_weapon(SPIKE_ER2)

declare_loadout({
    category         = CAT_MISSILES,
    CLSID            = "{SPIKE_ER2}",
    attribute        = SPIKE_ER2.wsTypeOfWeapon,
    Count            = 1,
    Cx_pil           = 0.0006265625,
    Picture          = "c701t.png",
    displayName      = _("SPIKE-ER2"),
    Weight           = 34,
    Elements         = {{ShapeName = "SPIKE_ER2"}},
    ejectVelocity    = 0,
})

declare_loadout({
    category         = CAT_MISSILES,
    CLSID            = "{SPIKE_ER}",
    attribute        = SPIKE_ER.wsTypeOfWeapon,
    Count            = 1,
    Cx_pil           = 0.0006265625,
    Picture          = "c701t.png",
    displayName      = _("SPIKE-ER"),
    Weight           = 34,
    Elements         = {{ShapeName = "SPIKE_ER"}},
    ejectVelocity    = 0,
})
